import * as React from "react";

import { Button, ButtonType, Layout, Position, SVG, SVGAsset } from "twitch-core-ui";

import { HoldDropdown } from "aegis/features/report-view/components/report-buttons/hold-button/hold-button-dropdown";
import { Report } from "aegis/features/reports";
import { ClickOutDetector } from "aegis/functionality/components/click-out-detector";
import { action, observable } from "mobx";
import { observer } from "mobx-react";

import "../styles.scss";

export enum TestSelectors {
  holdButton = "hold-button",
  holdForm = "hold-form"
}

export interface Props {
  report: Report;
  createHold: (duration: string) => void;
}

@observer
export class HoldButtonComponent extends React.Component<Props> {
  @observable private showDropdown = false;
  @observable private selectedHoldLength = "5m";

  public render() {
    const onClickNotPropogated = (e: React.MouseEvent) => {
      e.stopPropagation();
      this.showDropdown = !this.showDropdown;
    };

    const button = (
      <Button
        data-track-click="report-hold-show-dropdown"
        type={ButtonType.Hollow}
        onClick={onClickNotPropogated}
        data-test-selector={TestSelectors.holdButton}
      >
        <div className="report-button hold-button">
          <div className="button-text">Hold</div>
          <div className="report-button-icon-overlay">
            <SVG asset={SVGAsset.GlyphArrDown} />
          </div>
        </div>
      </Button>
    );

    return (
      <ClickOutDetector onClickOut={this.closeDropdown}>
        <Layout position={Position.Relative}>
          {button}
          <HoldDropdown
            data-test-selector={TestSelectors.holdForm}
            show={this.showDropdown}
            onHoldClicked={this.holdButtonClicked}
            setHoldDuration={this.setHoldLength}
            selectedHoldLength={this.selectedHoldLength}
            onCancelClicked={this.closeDropdown}
          />
        </Layout>
      </ClickOutDetector>
    );
  }

  @action
  private closeDropdown = () => {
    this.showDropdown = false;
  };

  @action
  private onHold = () => {
    this.closeDropdown();
  };

  @action
  private setHoldLength = (newLength: string) => {
    this.selectedHoldLength = newLength;
  };

  private holdButtonClicked = () => {
    this.props.createHold(this.selectedHoldLength);
    this.onHold();
  };
}
