import * as React from "react";

import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { Report } from "aegis/features/reports";
import { FETCH_MY_REPORT_COUNTS } from "aegis/features/reports/my-reports/header";
import * as Fragments from "aegis/fragments";
import { HoldButtonComponent } from "./component";

export const CREATE_HOLD_MUTATION = gql`
  mutation CreateHold($input: CreateReportHoldInput!) {
    createReportHold(input: $input) {
      report {
        ...ReportFields
      }
    }
  }
  ${Fragments.ReportFields}
`;

type CreateReportHoldInput = {
  input: {
    reportID: string;
    duration: string;
  };
};

type CreateReportHoldResponse = {
  createReportHold: {
    report?: Report;
  };
};

export interface HoldButtonProps {
  report: Report;
  onHold?: (report: Report) => void;
}

export class CreateReportHoldMutation extends Mutation<CreateReportHoldResponse, CreateReportHoldInput> {}

export const HoldButton: React.SFC<HoldButtonProps> = ({ report, onHold }) => {
  return (
    <CreateReportHoldMutation
      mutation={CREATE_HOLD_MUTATION}
      refetchQueries={[{ query: FETCH_MY_REPORT_COUNTS }]}
      onCompleted={data => {
        if (data && data.createReportHold.report && onHold) {
          onHold(data.createReportHold.report);
        }
      }}
    >
      {createHoldMutation => {
        const createHold = (duration: string) => {
          createHoldMutation({ variables: { input: { reportID: report.id, duration: duration } } });
        };
        return <HoldButtonComponent report={report} createHold={createHold} />;
      }}
    </CreateReportHoldMutation>
  );
};
