import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { HoldDropdown, Props, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupProps = (override?: Partial<Props>): Props => {
  return {
    show: false,
    setHoldDuration: jest.fn(),
    onHoldClicked: jest.fn(),
    selectedHoldLength: "5m",
    onCancelClicked: jest.fn(),
    ...override
  };
};

describe("hold card", () => {
  it("cancels on cancel", () => {
    const props = setupProps();
    const wrapper = Enzyme.shallow(<HoldDropdown {...props} />);
    const button = wrapper.find({ "data-test-selector": TestSelectors.cancelButton });
    expect(button).toHaveLength(1);
    button.simulate("click");
    expect(props.onCancelClicked).toHaveBeenCalled();
  });

  it("submits on submit", () => {
    const props = setupProps();
    const wrapper = Enzyme.shallow(<HoldDropdown {...props} />);
    const button = wrapper.find({ "data-test-selector": TestSelectors.submitButton });
    expect(button).toHaveLength(1);
    button.simulate("click");
    expect(props.onHoldClicked).toHaveBeenCalled();
  });
});
