import * as React from "react";

import { AncestorName, AncestorNameContextProvider } from "aegis/context/ancestor";

import {
  Background,
  Balloon,
  BalloonDirection,
  Button,
  ButtonType,
  Column,
  CoreText,
  Display,
  FlexDirection,
  Grid,
  JustifyContent,
  Layout,
  Overflow,
  SegmentedButton,
  SegmentedButtonOption,
  StyledLayout
} from "twitch-core-ui";

import "./styles.scss";

export enum TestSelectors {
  cancelButton = "cancel-button",
  submitButton = "submit-button"
}

export interface Props {
  show: boolean;
  setHoldDuration: (setLength: string) => void;
  onHoldClicked: () => void;
  selectedHoldLength: string;
  onCancelClicked: () => void;
}

export const HoldDropdown: React.SFC<Props> = props => {
  const getButton = ({ value, display }: { value: string; display: string }) => {
    return (
      <Column cols={4} key={`hold-dropdown-time-option-${value}`}>
        <Layout className="hold-dropdown-time-option" padding={{ bottom: 1 }}>
          <SegmentedButtonOption
            name={"hold-time-option"}
            label={display}
            checked={props.selectedHoldLength === value}
            onChange={() => props.setHoldDuration(value)}
          />
        </Layout>
      </Column>
    );
  };
  const options = [
    { value: "5m", display: "5 min" },
    { value: "10m", display: "10 min" },
    { value: "15m", display: "15 min" },
    { value: "30m", display: "30 min" },
    { value: "45m", display: "45 min" },
    { value: "60m", display: "60 min" }
  ];

  const buttons = options.map(getButton);
  return (
    <Balloon show={props.show} noTail direction={BalloonDirection.TopRight}>
      <AncestorNameContextProvider ancestorName={AncestorName.HoldDropdown}>
        <Layout flexGrow={0} overflow={Overflow.Hidden}>
          <StyledLayout
            overflow={Overflow.Hidden}
            display={Display.Flex}
            flexDirection={FlexDirection.Column}
            background={Background.Base}
            padding={1}
            className="reassign-dropdown"
          >
            <Layout padding={{ y: 0.5 }}>
              <CoreText> Select time to hold for this report:</CoreText>
            </Layout>
            <SegmentedButton>
              <Grid>{buttons}</Grid>
            </SegmentedButton>
            <StyledLayout borderTop display={Display.Flex} justifyContent={JustifyContent.Between} padding={{ top: 1 }}>
              <Button
                data-track-click="report-hold-dropdown-cancel"
                data-test-selector={TestSelectors.cancelButton}
                type={ButtonType.Hollow}
                onClick={props.onCancelClicked}
              >
                Cancel
              </Button>
              <Button
                data-track-click="report-hold-dropdown-submit"
                data-test-selector={TestSelectors.submitButton}
                onClick={props.onHoldClicked}
              >
                Set Hold
              </Button>
            </StyledLayout>
          </StyledLayout>
        </Layout>
      </AncestorNameContextProvider>
    </Balloon>
  );
};
