import * as React from "react";

import { AlignItems, Button, ButtonType, Display, Layout, SVG, SVGAsset, VerticalAlign } from "twitch-core-ui";
import { ButtonType as InvestigateButtonType } from "./container";

export interface Props {
  loading: boolean;
  type: InvestigateButtonType;
  error?: string;
  onClick: () => void;
}

export const InvestigateButtonComponent: React.SFC<Props> = ({ loading, type, error, onClick }) => {
  let buttonText = type === InvestigateButtonType.INVESTIGATE ? "Investigate" : "Release Report";
  if (error) {
    buttonText = `Error assigning: ${error}`;
  }

  const onClickNotPropogated = (e: React.MouseEvent) => {
    e.stopPropagation();
    onClick();
  };

  const dataTrack =
    type === InvestigateButtonType.INVESTIGATE
      ? "report-investigate-button--investigate"
      : "report-investigate-button--release";

  return (
    <Layout display={Display.Flex} alignItems={AlignItems.Center}>
      <Button
        data-track-click={dataTrack}
        onClick={onClickNotPropogated}
        disabled={loading}
        type={error ? ButtonType.Alert : ButtonType.Default}
      >
        <Layout verticalAlign={VerticalAlign.Middle} display={Display.Flex}>
          <Layout padding={{ right: 0.5 }} display={Display.InlineFlex}>
            {type === InvestigateButtonType.INVESTIGATE && <SVG asset={SVGAsset.GlyphViews} />}
            {type === InvestigateButtonType.CANCEL && <SVG asset={SVGAsset.Close} />}
          </Layout>
          {buttonText}
        </Layout>
      </Button>
    </Layout>
  );
};
