import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { MockAdmin } from "aegis/models/mocks";
import { AuthStore } from "aegis/stores";
import { InvestigativeQueueButtonsComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });
describe("Investigate Queue Buttons", () => {
  const mockedContextFuncs = { openStrikeForm: jest.fn() };
  it("renders when expanded", () => {
    const wrapper = Enzyme.shallow(
      <InvestigativeQueueButtonsComponent
        report={mockReport()}
        expanded
        authStore={new AuthStore()}
        {...mockedContextFuncs}
      />
    );

    expect(wrapper).toBeTruthy();
  });

  it("renders when when expanded and user matches session user", () => {
    const admin = MockAdmin();
    const report = mockReport({
      assignedto: admin
    });
    const authStore = new AuthStore();
    authStore.userLogin(admin);
    const wrapper = Enzyme.shallow(
      <InvestigativeQueueButtonsComponent report={report} expanded authStore={authStore} {...mockedContextFuncs} />
    );

    expect(wrapper).toBeTruthy();
  });

  it("renders when collapsed", () => {
    const wrapper = Enzyme.shallow(
      <InvestigativeQueueButtonsComponent
        report={mockReport()}
        expanded={false}
        authStore={new AuthStore()}
        {...mockedContextFuncs}
      />
    );

    expect(wrapper).toBeTruthy();
  });

  it("renders when when collapsed and user matches session user", () => {
    const admin = MockAdmin();
    const report = mockReport({
      assignedto: admin
    });
    const authStore = new AuthStore();
    authStore.userLogin(admin);
    const wrapper = Enzyme.shallow(
      <InvestigativeQueueButtonsComponent
        report={report}
        expanded={false}
        authStore={authStore}
        {...mockedContextFuncs}
      />
    );

    expect(wrapper).toBeTruthy();
  });
});
