import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { MainQueueButtons } from "./component";

Enzyme.configure({ adapter: new Adapter() });
describe("Main Queue Buttons", () => {
  it("renders when expanded", () => {
    const wrapper = Enzyme.shallow(<MainQueueButtons report={mockReport()} expanded />);

    expect(wrapper).toBeTruthy();
  });

  it("renders when collapsed", () => {
    const wrapper = Enzyme.shallow(<MainQueueButtons report={mockReport()} expanded={false} />);

    expect(wrapper).toBeTruthy();
  });
});
