import * as React from "react";

import { Report } from "aegis/features/reports";
import { User } from "aegis/models";
import { Display, FlexWrap, JustifyContent, Layout } from "twitch-core-ui";
import { HoldButton } from "../hold-button";
import { ReassignReportButton } from "../reassign-button";
import { ResolveReportButton } from "../resolve-button";
import { StrikeButton } from "../strike-button";

import "../styles.scss";

export interface Props {
  report: Report;
  expanded?: boolean;
  onStrike?: (User?: User) => void;
  onResolve?: (report: Report) => void;
  onReassign?: (report: Report) => void;
  onHold?: (report: Report) => void;
}

export class MainQueueButtons extends React.Component<Props> {
  public render() {
    const { report, expanded, onStrike, onResolve, onReassign, onHold } = this.props;
    const resolved = report.status === "resolved";

    const strikeButton = <StrikeButton report={report} onStrike={onStrike} />;
    const resolveButton = <ResolveReportButton report={report} resolved={resolved} onResolve={onResolve} />;
    const holdButton = <HoldButton report={report} onHold={onHold} />;
    const reassignButton = <ReassignReportButton report={report} onReassign={onReassign} />;

    if (expanded) {
      return (
        <Layout display={Display.Flex} flexWrap={FlexWrap.NoWrap} justifyContent={JustifyContent.Between}>
          <Layout display={Display.Flex} flexWrap={FlexWrap.NoWrap}>
            <Layout padding={{ right: 0.5 }}>{strikeButton}</Layout>
            <Layout padding={{ x: 0.5 }}>{resolveButton}</Layout>
            <Layout padding={{ left: 0.5 }}>{reassignButton}</Layout>
          </Layout>
          <Layout padding={{ x: 0.5 }}>{holdButton}</Layout>
        </Layout>
      );
    } else {
      return (
        <Layout display={Display.Flex} flexWrap={FlexWrap.NoWrap}>
          <Layout padding={{ x: 0.5 }}>{resolveButton}</Layout>
          <Layout padding={{ left: 0.5 }}>{reassignButton}</Layout>
        </Layout>
      );
    }
  }
}
