import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { Provider } from "mobx-react";
import { MockedProvider } from "react-apollo/test-utils";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { FETCH_REPORT_ADMINS } from "aegis/functionality/components/admin-select";
import { MockAdmin } from "aegis/models/mocks";
import { ReportStore } from "aegis/stores";
import { mockSuccessResponse } from "aegis/tests/apollo";
import { Button } from "twitch-core-ui";
import { ASSIGN_REPORT_TO_ADMIN } from "../../mutations/assign-report-to-admin";
import { ReassignButtonProps, ReassignReportButton } from "./container";
import { ReassignDropdown } from "./reassign-dropdown";

Enzyme.configure({ adapter: new Adapter() });

const mockReassignReportSuccess = mockSuccessResponse(
  ASSIGN_REPORT_TO_ADMIN,
  { input: { id: "12345" } },
  {
    data: {
      resolveReport: {
        report: {
          ...mockReport({ id: "12345", status: "resolved" })
        },
        __typename: "LegacyReport"
      }
    }
  }
);

const mockReportAdmins = mockSuccessResponse(
  FETCH_REPORT_ADMINS,
  {},
  {
    data: {
      reportAdmins: [MockAdmin()]
    }
  }
);

function setupMount(overrides?: Partial<ReassignButtonProps>) {
  return Enzyme.mount(
    <MockedProvider mocks={[mockReassignReportSuccess, mockReportAdmins]}>
      <Provider reportStore={new ReportStore()}>
        <ReassignReportButton
          report={mockReport({
            id: "12345",
            status: "resolved"
          })}
          onReassign={jest.fn()}
          {...overrides}
        />
      </Provider>
    </MockedProvider>
  );
}

describe("ReassignButton", () => {
  it("opens reassign card on dropdown", () => {
    const wrapper = setupMount();
    const button = wrapper.find(Button);
    button.simulate("click");
    wrapper.update();
    expect(wrapper.find(ReassignDropdown).prop("show")).toBe(true);
  });
});
