import * as React from "react";

import { action, observable } from "mobx";
import { observer } from "mobx-react";

import { Report } from "aegis/features/reports";
import { ClickOutDetector } from "aegis/functionality/components/click-out-detector";
import { Button, Layout, Position, SVG, SVGAsset } from "twitch-core-ui";
import { ReassignDropdown } from "./reassign-dropdown";

export interface ReassignButtonComponentProps {
  report: Report;
  loading: boolean;
  success?: boolean;
  submitReassign: (adminLdap: string) => void;
  assignToQueueWithLanguage: (language: string) => void;
}

@observer
export class ReassignReportButtonComponent extends React.Component<ReassignButtonComponentProps> {
  @observable showDropdown = false;
  public render() {
    const { loading, success } = this.props;
    let buttonText = "Reassign";
    if (loading) {
      buttonText = "Reassigning";
    }
    if (success) {
      buttonText = "Reassigned";
    }

    const onClickNotPropogated = (e: React.MouseEvent) => {
      e.stopPropagation();
      this.showDropdown = !this.showDropdown;
    };

    const button = (
      <Button data-track-click="report-reassign-show-dropdown" onClick={onClickNotPropogated} disabled={loading}>
        <div className="report-button">
          <div className="button-text">{buttonText}</div>
          <div className="report-button-icon-overlay">{<SVG asset={SVGAsset.GlyphArrDown} />}</div>
        </div>
      </Button>
    );

    return (
      <ClickOutDetector onClickOut={this.closeDropdown}>
        <Layout position={Position.Relative}>
          {button}
          <ReassignDropdown
            show={this.showDropdown}
            submitReassign={this.onReassign}
            assignToQueueWithLanguage={this.props.assignToQueueWithLanguage}
            report={this.props.report}
          />
        </Layout>
      </ClickOutDetector>
    );
  }

  @action
  private closeDropdown = () => {
    this.showDropdown = false;
  };

  @action
  private onReassign = (adminLdap: string) => {
    this.showDropdown = false;
    this.props.submitReassign(adminLdap);
  };
}
