import * as React from "react";

import {
  AlignItems,
  CoreText,
  Display,
  Interactable,
  InteractableType,
  JustifyContent,
  Layout,
  SVG,
  SVGAsset
} from "twitch-core-ui";

export interface Props {
  onClick: () => void;
}

// Temporary placeholder component. To be implemented in https://jira.twitch.com/browse/SAFETY-1560
export const AssignToCheckLaterLinkComponent: React.SFC<Props> = props => {
  const onClick = (e: React.MouseEvent) => {
    e.stopPropagation();
    props.onClick();
  };

  return (
    <Interactable
      data-track-click="report-assign-to-investigative-show-modal"
      onClick={onClick}
      type={InteractableType.Alt}
    >
      <Layout
        display={Display.InlineFlex}
        justifyContent={JustifyContent.Between}
        alignItems={AlignItems.Center}
        fullWidth
        padding={1}
      >
        <CoreText>to Investigative Queue</CoreText>

        <SVG asset={SVGAsset.AngleRight} />
      </Layout>
    </Interactable>
  );
};
