import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";

import { CheckLaterModalComponent, QuickSelectButton, TestSelectors } from "./component";

const mockedReport = mockReport({ id: "12345", status: "resolved", language: "test" });

Enzyme.configure({ adapter: new Adapter() });
describe("Check later modal", () => {
  it("assigns to queue with language of report by default", () => {
    const assignToQueueWithLanguage = jest.fn();
    const wrapper = Enzyme.shallow(
      <CheckLaterModalComponent report={mockedReport} assignToQueueWithLanguage={assignToQueueWithLanguage} />
    );

    wrapper.find({ "data-test-selector": TestSelectors.AssignButton }).simulate("click");
    expect(assignToQueueWithLanguage).toHaveBeenCalledWith("test");
  });

  it("assigns to queue with quick selected language", () => {
    const assignToQueueWithLanguage = jest.fn();
    const wrapper = Enzyme.shallow(
      <CheckLaterModalComponent report={mockedReport} assignToQueueWithLanguage={assignToQueueWithLanguage} />
    );

    wrapper
      .find(QuickSelectButton)
      .first() // Takes first quick select button, "en"
      .dive() // Mounts QuickSelectButton component, giving us access to the button it renders
      .find({ "data-test-selector": TestSelectors.QuickSelectLanguageButton })
      .simulate("click");

    wrapper.find({ "data-test-selector": TestSelectors.AssignButton }).simulate("click");
    expect(assignToQueueWithLanguage).toHaveBeenCalledWith("en");
  });
});
