import * as React from "react";

import { Report } from "aegis/features/reports";
import { PortalModal } from "aegis/functionality/components/portal-modal";
import { action, observable } from "mobx";
import { observer } from "mobx-react";
import { AssignToCheckLaterLinkComponent } from "./check-later-button";
import { CheckLaterModalComponent } from "./check-later-modal";

export interface Props {
  report: Report;
  assignToQueueWithLanguage: (language: string) => void;
}

@observer
export class AssignToCheckLater extends React.Component<Props> {
  @observable showCheckLaterModal = false;

  private get checkLaterForm(): JSX.Element | null {
    if (!this.showCheckLaterModal) {
      return null;
    }

    return (
      <PortalModal onClose={this.hideModal}>
        <CheckLaterModalComponent
          closeModal={this.hideModal}
          report={this.props.report}
          assignToQueueWithLanguage={this.assignToQueue}
        />
      </PortalModal>
    );
  }

  public render() {
    return (
      <>
        <AssignToCheckLaterLinkComponent onClick={this.showModal} />
        {this.checkLaterForm}
      </>
    );
  }

  @action
  private showModal = () => {
    this.showCheckLaterModal = true;
  };

  @action
  private hideModal = () => {
    this.showCheckLaterModal = false;
  };

  private assignToQueue = (language: string) => {
    this.hideModal();
    this.props.assignToQueueWithLanguage(language);
  };
}
