import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { ReportStore } from "aegis/stores";
import { ReassignDropdown } from "./component";

const mockedReport = mockReport({ id: "12345", status: "resolved" });

Enzyme.configure({ adapter: new Adapter() });
describe("Reassign dropdown", () => {
  const reportStore = new ReportStore();
  it("renders with no admins", () => {
    const wrapper = Enzyme.shallow(
      <ReassignDropdown
        show
        report={mockedReport}
        reportStore={reportStore}
        submitReassign={jest.fn()}
        assignToQueueWithLanguage={jest.fn()}
      />
    );

    expect(wrapper).toBeTruthy();
  });

  it("renders with admins", () => {
    const wrapper = Enzyme.shallow(
      <ReassignDropdown
        show
        reportStore={reportStore}
        report={mockedReport}
        submitReassign={jest.fn()}
        assignToQueueWithLanguage={jest.fn()}
      />
    );

    expect(wrapper).toBeTruthy();
  });

  it("renders with when expanded", () => {
    const rs = new ReportStore();
    rs.expand(mockedReport.id);

    const wrapper = Enzyme.shallow(
      <ReassignDropdown
        show
        reportStore={rs}
        report={mockedReport}
        submitReassign={jest.fn()}
        assignToQueueWithLanguage={jest.fn()}
      />
    );

    expect(wrapper).toBeTruthy();
  });
});
