import * as React from "react";

import { inject } from "mobx-react";

import { AncestorName, AncestorNameContextProvider } from "aegis/context/ancestor";
import { Report } from "aegis/features/reports";
import { Admin } from "aegis/models";
import { ReportStoreProps } from "aegis/stores";
import { AssignToCheckLater } from "./assign-to-check-later-link/component";

import {
  Background,
  Balloon,
  BalloonDirection,
  CoreText,
  Display,
  FlexDirection,
  Layout,
  Overflow,
  StyledLayout
} from "twitch-core-ui";

import { AdminSelect } from "aegis/functionality/components/admin-select";
import "./styles.scss";

export interface Props {
  report: Report;
  show: boolean;
  submitReassign: (adminLdap: string) => void;
  assignToQueueWithLanguage: (language: string) => void;
}

@inject("reportStore")
export class ReassignDropdown extends React.Component<Props & ReportStoreProps> {
  public render() {
    const { show, submitReassign, assignToQueueWithLanguage, report, reportStore } = this.props;

    return (
      <Balloon
        show={show}
        noTail
        direction={reportStore!.isExpanded(report.id) ? BalloonDirection.Top : BalloonDirection.Bottom}
      >
        <AncestorNameContextProvider ancestorName={AncestorName.ReassignDropdown}>
          <StyledLayout
            display={Display.Flex}
            flexDirection={FlexDirection.Column}
            background={Background.Base}
            overflow={Overflow.Hidden}
            className="reassign-dropdown"
            padding={{ bottom: 1 }}
          >
            <StyledLayout borderBottom>
              <AssignToCheckLater report={report} assignToQueueWithLanguage={assignToQueueWithLanguage} />
            </StyledLayout>
            <Layout padding={{ y: 1, x: 1 }}>
              <CoreText noWrap>Select user to reassign to:</CoreText>
            </Layout>

            <Layout padding={{ y: 0.5, x: 1 }}>
              <AdminSelect onSelect={(admin: Admin) => submitReassign(admin ? admin.ldap : "")} />
            </Layout>
          </StyledLayout>
        </AncestorNameContextProvider>
      </Balloon>
    );
  }
}
