import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { TestProvider } from "aegis/tests/utils/test-provider";
import { Button } from "twitch-core-ui";
import { AutoResolveButtonComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });
describe("Auto Resolve Button", () => {
  it("renders when disabled", () => {
    const wrapper = Enzyme.shallow(
      <TestProvider>
        <AutoResolveButtonComponent disabled onClick={jest.fn()} />
      </TestProvider>
    );

    expect(wrapper).toBeTruthy();
  });

  it("renders when not disabled", () => {
    const wrapper = Enzyme.shallow(
      <TestProvider>
        <AutoResolveButtonComponent disabled={false} onClick={jest.fn()} />
      </TestProvider>
    );

    expect(wrapper).toBeTruthy();
  });

  it("renders with tooltip", () => {
    const wrapper = Enzyme.shallow(
      <TestProvider>
        <AutoResolveButtonComponent tooltip={"tooltip"} disabled onClick={jest.fn()} />
      </TestProvider>
    );

    expect(wrapper).toBeTruthy();
  });

  it("calls onClick when button is clicked", () => {
    const fn = jest.fn();
    const wrapper = Enzyme.mount(
      <TestProvider>
        <AutoResolveButtonComponent disabled={false} onClick={fn} />
      </TestProvider>
    );

    wrapper.find(Button).simulate("click");
    expect(fn.mock.calls.length).toBe(1);
  });
});
