import * as React from "react";

import { AlignItems, Button, ButtonType, Display, Layout, Tooltip, VerticalAlign } from "twitch-core-ui";

export interface Props {
  disabled: boolean;
  error?: string;
  tooltip?: string;
  onClick: () => void;
}

export const AutoResolveButtonComponent: React.SFC<Props> = ({ error, tooltip, disabled, onClick }) => {
  let buttonText = "Set Autoresolve";
  if (error) {
    buttonText = `Error assigning: ${error}`;
  }

  const onClickNotPropogated = (e: React.MouseEvent) => {
    e.stopPropagation();
    onClick();
  };

  const button = (
    <Button
      data-track-click="auto-resolve-submit"
      onClick={onClickNotPropogated}
      disabled={disabled}
      type={error ? ButtonType.Alert : ButtonType.Default}
    >
      <Layout verticalAlign={VerticalAlign.Middle} display={Display.Flex}>
        {buttonText}
      </Layout>
    </Button>
  );

  return (
    <Layout display={Display.Flex} alignItems={AlignItems.Center}>
      {tooltip ? <Tooltip label={tooltip}>{button}</Tooltip> : button}
    </Layout>
  );
};
