import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { MockedProvider } from "react-apollo/test-utils";

import { FETCH_REPORT_CONTENTS } from "aegis/features/report-content-dropdown";
import { FETCH_REPORT_REASONS } from "aegis/features/report-reason-dropdown";
import { mockReport } from "aegis/features/report-view/reportMocks";
import { MockReportContent, MockReportReason } from "aegis/models/mocks/report";
import { mockSuccessResponse } from "aegis/tests/apollo";
import { TestProvider } from "aegis/tests/utils/test-provider";
import { ResolveReportButtonComponent } from "./component";
import { RESOLVE_REPORT, ResolveButtonProps, ResolveReportButton } from "./container";

Enzyme.configure({ adapter: new Adapter() });

const mockResolveReportSuccess = mockSuccessResponse(
  RESOLVE_REPORT,
  { input: { id: "12345" } },
  {
    data: {
      resolveReport: {
        report: {
          ...mockReport({ id: "12345", status: "resolved" })
        },
        __typename: "LegacyReport"
      }
    }
  }
);

const mockReportContentsSuccess = mockSuccessResponse(
  FETCH_REPORT_CONTENTS,
  {},
  {
    data: {
      reportContents: [MockReportContent()]
    }
  }
);

const mockReportReasonsSuccess = mockSuccessResponse(
  FETCH_REPORT_REASONS,
  {},
  {
    data: {
      reportReasons: [MockReportReason()]
    }
  }
);

function setupMount(overrides?: Partial<ResolveButtonProps>) {
  return Enzyme.mount(
    <TestProvider>
      <MockedProvider mocks={[mockResolveReportSuccess, mockReportContentsSuccess, mockReportReasonsSuccess]}>
        <ResolveReportButton report={mockReport()} onResolve={jest.fn()} {...overrides} />
      </MockedProvider>
    </TestProvider>
  );
}

describe("ResolveButton", () => {
  it("renders with default button type when unresolved", () => {
    const wrapper = setupMount();
    expect(wrapper.find(".button-text").text()).toBe("Resolve");
  });

  it("renders with success button type when resolved", () => {
    const wrapper = setupMount({ resolved: true });
    expect(wrapper.find(".button-text").text()).toBe("Resolved");
  });

  it("renders resolved state on resolved report", () => {
    const wrapper = Enzyme.shallow(
      <ResolveReportButtonComponent report={mockReport()} loading={false} onClick={jest.fn()} success={true} />
    );
    expect(wrapper.find(".button-text").text()).toBe("Resolved");
  });
});
