import * as React from "react";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { mount } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { UserRole } from "aegis/models";
import { MockUser } from "aegis/models/mocks";
import { StrikeButton } from "./";
import { TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Report Strike button", () => {
  it("renders for regular user and clicking strike invokes onStrike function", () => {
    const mockFn = jest.fn();
    const wrapper = mount(<StrikeButton report={mockReport()} onStrike={mockFn} />);

    wrapper
      .find({ "data-test-selector": TestSelectors.RegularStrikeButton })
      .hostNodes()
      .simulate("click");

    expect(mockFn.mock.calls.length).toBe(1);
  });

  it("renders for partner and clicking ", () => {
    const wrapper = mount(
      <StrikeButton
        report={mockReport({
          targetUser: MockUser({
            roles: [UserRole.Partner],
            login: "targetUserLogin"
          })
        })}
      />
    );

    expect(wrapper.find({ "data-test-selector": TestSelectors.PartnerConductFormButton }).hostNodes()).toBeTruthy();
  });

  // missing it("renders for partner and expanding split button allows clicking of strike button")
  // Core-UI's split button doesn't allow us to pass data-test-selector to the dropdown and we have no control over where it is
  // Using hacky solution like find button # 2 will probably result in test breaking due to core-ui update than catching real issues
});
