import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockReportComment } from "aegis/models/mocks/report";
import { CommentBox } from "./";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

describe("ReportCommentBox", () => {
  it("renders without border", () => {
    const wrapper = Enzyme.shallow(<CommentBox comment={MockReportComment()} />);
    expect(wrapper).toBeTruthy();
  });

  it("renders with border", () => {
    const wrapper = Enzyme.shallow(<CommentBox comment={MockReportComment()} border />);
    expect(wrapper).toBeTruthy();
  });
});
