import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { AncestorName } from "aegis/context/ancestor";
import { Button, TextArea } from "twitch-core-ui";
import { ReportCommentInputComponent } from "./";

Enzyme.configure({ adapter: new Adapter() });

const mockFormChangeEvent = ({ currentTarget: { value: "Test comment" } } as {}) as React.FormEvent<
  HTMLTextAreaElement
>;

describe("ReportCommentInput", () => {
  it("Renders without button visible", () => {
    const wrapper = Enzyme.shallow(
      <ReportCommentInputComponent
        createComment={jest.fn()}
        ancestorName={AncestorName.ReportCard}
        onComplete={jest.fn()}
      />
    );
    expect(wrapper.find(Button).length).toBe(0);
  });

  it("Renders button when text is changed", () => {
    const wrapper = Enzyme.shallow(
      <ReportCommentInputComponent
        createComment={jest.fn()}
        ancestorName={AncestorName.ReportCard}
        onComplete={jest.fn()}
      />
    );
    wrapper
      .find(TextArea)
      .props()
      .onChange(mockFormChangeEvent);
    wrapper.update();

    expect(wrapper.find(TextArea).props().value).toBe("Test comment");
    expect(wrapper.find(Button).length).toBe(1);
  });

  it("Wipes text field when comment is submitted", () => {
    const wrapper = Enzyme.shallow(
      <ReportCommentInputComponent
        createComment={jest.fn()}
        ancestorName={AncestorName.ReportCard}
        onComplete={jest.fn()}
      />
    );
    wrapper
      .find(TextArea)
      .props()
      .onChange(mockFormChangeEvent);
    wrapper.update();
    wrapper.find(Button).simulate("click");
    wrapper.update();

    expect(wrapper.find(TextArea).props().value).toBe("");
    expect(wrapper.find(Button).length).toBe(0);
  });
});
