import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { MockedProvider } from "react-apollo/test-utils";
import { Router } from "react-router-dom";

import { ChatColumnNameOverrides, MessageColumn } from "aegis/features/messages";
import { pagedResponseWithNMessages } from "aegis/features/messages/mocks";
import * as ReportModels from "aegis/features/reports/models";
import { createHistory } from "aegis/functionality/utils/contrib/twilight/history";
import { ChatEmbed, TestSelectors } from "./chat-embed";
import { NewChatReport } from "./testutil";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

function setupMount(overrides?: Partial<ReportModels.ChatReport>) {
  const report = NewChatReport(overrides ? overrides : {});
  return Enzyme.mount(
    <Router history={createHistory()}>
      <MockedProvider>
        <ChatEmbed report={report} />
      </MockedProvider>
    </Router>
  );
}

describe("ChatEmbed", () => {
  it("renders error message when no messages are returned", () => {
    const wrapper = setupMount({ entries: pagedResponseWithNMessages(0) });

    expect(wrapper.find({ "data-test-selector": TestSelectors.ErrorMessage }).hostNodes().length).toBe(1);

    expect(wrapper.find({ "data-test-selector": TestSelectors.MessageEntries }).length).toBe(0);
  });

  it("renders ui correctly", () => {
    const wrapper = setupMount({ entries: pagedResponseWithNMessages(10) });

    expect(wrapper.find({ "data-test-selector": TestSelectors.ErrorMessage }).hostNodes().length).toBe(0);

    expect(wrapper.find({ "data-test-selector": TestSelectors.MessageEntries }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.MessageEntries }).props()).toMatchObject({
      columnNameOverride: ChatColumnNameOverrides,
      chatColumns: [MessageColumn.Time, MessageColumn.From, MessageColumn.Message, MessageColumn.Actions]
    });
    expect(wrapper.find({ "data-test-selector": TestSelectors.MessageEntries }).prop("entries").length).toBe(10);
  });
});
