import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import * as ReportModels from "aegis/features/reports/models";
import { ReportContentCode } from "aegis/models";
import { MockReportContent } from "aegis/models/mocks/report";
import { ChatEmbed } from "./chat-embed";
import { ClipEmbed } from "./clip-embed";
import { ReportEmbedComponent } from "./component";
import { CurseReportEmbed } from "./curse-report-embed";
import { LegacyEmbed } from "./legacy-embed";
import { NewReport } from "./testutil";
import { UserEmbed } from "./user-embed";
import { VodEmbed } from "./vod-embed";

Enzyme.configure({ adapter: new Adapter() });

describe("Report Embeds", () => {
  it("renders curse whisper report with right embed", () => {
    const report = NewReport() as ReportModels.CurseWhisperReport;
    report.content = MockReportContent({ code: ReportContentCode.CurseWhisper });
    report.messages = [];

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(CurseReportEmbed).length).toBe(1);
  });

  it("renders curse public group report with right embed", () => {
    const report = NewReport() as ReportModels.CursePublicGroupReport;
    report.content = MockReportContent({ code: ReportContentCode.CursePublicGroup });
    report.messages = [];

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(CurseReportEmbed).length).toBe(1);
  });

  it("renders curse private group report with right embed", () => {
    const report = NewReport() as ReportModels.CursePrivateGroupReport;
    report.content = MockReportContent({ code: ReportContentCode.CursePrivateGroup });
    report.messages = [];

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(CurseReportEmbed).length).toBe(1);
  });

  it("renders chat report with right embed", () => {
    const report = NewReport() as ReportModels.UserReport;
    report.content = MockReportContent({ code: ReportContentCode.Chat });
    report.chatPopupURL = "chatPopupURL";

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(ChatEmbed).length).toBe(1);
  });

  it("renders clip report with right embed", () => {
    const report = NewReport() as ReportModels.ClipReport;
    report.content = MockReportContent({ code: ReportContentCode.Clip });
    report.clipURL = "clipURL";

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(ClipEmbed).length).toBe(1);
  });

  it("renders user report with right embed", () => {
    const report = NewReport() as ReportModels.UserReport;
    report.content = MockReportContent({ code: ReportContentCode.User });
    report.chatPopupURL = "chatPopupURL";

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(UserEmbed).length).toBe(1);
  });

  it("renders vod report with right embed", () => {
    const report = NewReport() as ReportModels.VodReport;
    report.content = MockReportContent({ code: ReportContentCode.Vod });

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(VodEmbed).length).toBe(1);
  });

  it("renders legacy report with right embed", () => {
    const report = NewReport() as ReportModels.LegacyReport;
    report.extra = "extra";
    report.details = "details";
    report.contentID = "contentID";
    report.content = MockReportContent({ code: undefined });

    const wrapper = Enzyme.shallow(<ReportEmbedComponent report={report} />);
    expect(wrapper.find(LegacyEmbed).length).toBe(1);
  });
});
