import * as React from "react";

import {
  ChatReport,
  ClipReport,
  CursePrivateGroupReport,
  CursePublicGroupReport,
  CurseWhisperReport,
  EmoteReport,
  ExtensionReport,
  LegacyReport,
  LiveUpNotificationReport,
  Report,
  RoomReport,
  UserReport,
  VodCommentReport,
  VodReport,
  WhisperReport
} from "aegis/features/reports";
import { ArrowIconType, CollapsibleCard } from "aegis/functionality/components/collapsible";
import { ReportContentCode } from "aegis/models";
import { BorderRadius, CoreText, StyledLayout } from "twitch-core-ui";
import {
  ChatEmbed,
  ClipEmbed,
  CurseReportEmbed,
  EmoteEmbed,
  ExtensionEmbed,
  LegacyEmbed,
  LiveUpNotificationEmbed,
  RoomEmbed,
  UserEmbed,
  VodCommentEmbed,
  VodEmbed,
  WhisperReportEmbed
} from ".";

interface Props {
  report: Report;
}

export class ReportEmbedComponent extends React.Component<Props, {}> {
  public render() {
    const { report } = this.props;

    return (
      <CollapsibleCard
        arrowIconType={ArrowIconType.Angle}
        title={<CoreText bold>{`${report.content.displayName} Report Details`}</CoreText>}
        roundedCorner
      >
        <StyledLayout
          border
          borderRadius={{
            bottomRight: BorderRadius.Medium,
            bottomLeft: BorderRadius.Medium
          }}
        >
          {this.renderEmbed()}
        </StyledLayout>
      </CollapsibleCard>
    );
  }

  private renderEmbed() {
    const { report } = this.props;
    switch (report.content.code) {
      case ReportContentCode.Chat:
        return <ChatEmbed report={report as ChatReport} />;
      case ReportContentCode.Clip:
        return <ClipEmbed report={report as ClipReport} />;
      case ReportContentCode.CursePrivateGroup:
        return <CurseReportEmbed messages={(report as CursePrivateGroupReport).messages} />;
      case ReportContentCode.CursePublicGroup:
        return <CurseReportEmbed messages={(report as CursePublicGroupReport).messages} />;
      case ReportContentCode.CurseWhisper:
        return <CurseReportEmbed messages={(report as CurseWhisperReport).messages} />;
      case ReportContentCode.Emote:
        return <EmoteEmbed report={report as EmoteReport} />;
      case ReportContentCode.Extension:
        return <ExtensionEmbed report={report as ExtensionReport} />;
      case ReportContentCode.LiveUp:
        return <LiveUpNotificationEmbed report={report as LiveUpNotificationReport} />;
      case ReportContentCode.Room:
        return <RoomEmbed report={report as RoomReport} />;
      case ReportContentCode.User:
        return <UserEmbed report={report as UserReport} />;
      case ReportContentCode.VodComment:
        return <VodCommentEmbed report={report as VodCommentReport} />;
      case ReportContentCode.Vod:
        return <VodEmbed report={report as VodReport} />;
      case ReportContentCode.Whisper:
        return <WhisperReportEmbed report={report as WhisperReport} />;
      default:
        return <LegacyEmbed report={report as LegacyReport} />;
    }
  }
}
