import * as React from "react";

import {
  AlignItems,
  BorderRadius,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Interactable,
  InteractableType,
  Layout,
  SVG,
  SVGAsset,
  TextType
} from "twitch-core-ui";

import { ReportActionContext, withReportActionContext } from "aegis/features/report-view/context";
import { User } from "aegis/features/user";
import { User as UserModel } from "aegis/models";

export interface Props {
  user: UserModel;
}

interface ContextProps {
  openStrikeForm: (User?: UserModel) => void;
}

export const StrikeableClipCuratorComponent: React.SFC<Props & ContextProps> = ({ user, openStrikeForm }) => {
  return (
    <Layout display={Display.Flex} flexDirection={FlexDirection.Column} flexGrow={0} alignItems={AlignItems.Start}>
      <User user={user} showStatus showType />
      <Layout flexGrow={0}>
        <Interactable
          data-track-click="report-strike-clip-curator"
          onClick={() => {
            openStrikeForm(user);
          }}
          type={InteractableType.Alpha}
          borderRadius={BorderRadius.Medium}
        >
          <Layout display={Display.Flex} padding={{ top: 0.5, bottom: 0.5 }}>
            <CoreText type={TextType.Span} fontSize={FontSize.Size6}>
              Strike clipper
            </CoreText>
            <SVG asset={SVGAsset.AngleRight} width={15} height={15} />
          </Layout>
        </Interactable>
      </Layout>
    </Layout>
  );
};

function mapContextToProps(context: ReportActionContext): ContextProps {
  return { openStrikeForm: context.openStrikeForm };
}
export const StrikeableClipCurator = withReportActionContext<ContextProps, Props>(mapContextToProps)(
  StrikeableClipCuratorComponent
);
