import * as React from "react";

import { CollapsibleMessageLog, Message, MessageColumn } from "aegis/features/messages";
import { Color, Display, StyledLayout } from "twitch-core-ui";

export const DataSelector = {
  Messages: "curseReportEmbed.messages"
};

interface Props {
  messages: Message[];
}

export const CurseReportEmbed: React.SFC<Props> = ({ messages }) => {
  return (
    <StyledLayout color={Color.Alt2} display={Display.Flex}>
      <CollapsibleMessageLog
        data-test-selector={DataSelector.Messages}
        entries={messages}
        chatColumns={[MessageColumn.Time, MessageColumn.From, MessageColumn.Message]}
      />
    </StyledLayout>
  );
};
