import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { EmoteEmbed, TestSelectors } from "./emote-embed";
import { NewEmoteReport } from "./testutil";

Enzyme.configure({ adapter: new Adapter() });

it("renders with emote", () => {
  const wrapper = Enzyme.shallow(<EmoteEmbed report={NewEmoteReport()} />);
  expect(wrapper.find({ "data-test-selector": TestSelectors.Display }).exists()).toBeTruthy();
});

it("renders without emote", () => {
  const wrapper = Enzyme.shallow(<EmoteEmbed report={NewEmoteReport({ emote: undefined })} />);
  expect(wrapper.find({ "data-test-selector": TestSelectors.Error }).exists()).toBeTruthy();
});
