import * as React from "react";

import { Emote, Props as EmoteProps } from "aegis/features/emote";
import { EmoteReport } from "aegis/features/reports";
import { Color, CoreText, Display, FlexDirection, JustifyContent, Layout } from "twitch-core-ui";

interface Props {
  report: EmoteReport;
}

export enum TestSelectors {
  Error = "emote-embed-errors",
  Display = "emote-embed-display"
}

export const EmoteEmbed: React.SFC<Props> = ({ report }) => {
  const { emote } = report;

  if (!emote) {
    return (
      <CoreText data-test-selector={TestSelectors.Error} color={Color.Error}>
        This report has no emote
      </CoreText>
    );
  }

  return (
    <Layout display={Display.Flex} flexDirection={FlexDirection.Column} data-test-selector={TestSelectors.Display}>
      <Layout>
        <CoreText>Code: {emote.code}</CoreText>
      </Layout>
      <Layout display={Display.Flex}>
        <EmoteComponent id={emote.id} emoteCode={emote.code} version={1} />
        <EmoteComponent id={emote.id} emoteCode={emote.code} version={2} />
        <EmoteComponent id={emote.id} emoteCode={emote.code} version={3} />
      </Layout>
    </Layout>
  );
};

const EmoteComponent: React.SFC<EmoteProps> = props => {
  return (
    <Layout
      padding={{ left: 1 }}
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      justifyContent={JustifyContent.End}
    >
      <Emote {...props} />
    </Layout>
  );
};
