import * as ReportModels from "aegis/features/reports/models";
import "aegis/functionality/date-extensions";
import { createHistory } from "aegis/functionality/utils/contrib/twilight/history";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import * as React from "react";
import { MockedProvider } from "react-apollo/test-utils";
import { Router } from "react-router-dom";
import { Button } from "twitch-core-ui";
import { ExtensionEmbed, TestSelectors } from "./extension-embed";
import { NewExtensionReport } from "./testutil";

Enzyme.configure({ adapter: new Adapter() });

function setupMount(overrides?: Partial<ReportModels.ExtensionReport>) {
  const report = NewExtensionReport(overrides ? overrides : {});
  return Enzyme.mount(
    <Router history={createHistory()}>
      <MockedProvider>
        <ExtensionEmbed report={report} />
      </MockedProvider>
    </Router>
  );
}

describe("ExtensionEmbed", () => {
  it("renders placeholder when no extensionURL is provided", () => {
    const wrapper = setupMount({ extensionURL: undefined });

    expect(wrapper.text()).toBe("Couldn't fetch the info for this extension");
  });

  it("renders ui correctly", () => {
    const wrapper = setupMount();

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.ExtensionPageButton })
        .filter(Button)
        .text()
    ).toBe("Extension Page");

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.CopyEmailTemplateButton })
        .filter(Button)
        .text()
    ).toBe("Copy email template");
  });
});
