import { ExtensionReport } from "aegis/features/reports";
import { copyTextToClipboard } from "aegis/functionality/utils/contrib/twilight/copy-text-to-clipboard";
import * as React from "react";
import {
  Button,
  ButtonSize,
  ButtonType,
  Color,
  CoreText,
  Display,
  StyledLayout,
  SVGAsset,
  TextAlign
} from "twitch-core-ui";

interface Props {
  report: ExtensionReport;
}

export enum TestSelectors {
  ExtensionPageButton = "extension-page-button",
  CopyEmailTemplateButton = "copy-email-template-button"
}

export const ExtensionEmbed: React.SFC<Props> = ({ report }) => {
  const { extensionID, extensionURL, description, targetUser } = report;

  if (!extensionID || !extensionURL || !targetUser) {
    return <CoreText color={Color.Error}>Couldn't fetch the info for this extension</CoreText>;
  }

  const emailTemplate = `
  ExtensionID: ${extensionID}
  Channel: ${targetUser!.login} (${targetUser!.id})
  User Description: ${description}
  Admin Note:
  `;
  const copyEmailTemplateToClipboard = (event: React.MouseEvent<HTMLElement>) => {
    event.stopPropagation();
    copyTextToClipboard(emailTemplate);
  };

  return (
    <StyledLayout color={Color.Alt2} display={Display.Flex}>
      <StyledLayout fullWidth textAlign={TextAlign.Center} borderRight flexOrder={0}>
        <Button
          data-track-click="report-extension-embed-extension-page"
          type={ButtonType.Text}
          icon={SVGAsset.LogoGlitch}
          fullWidth
          linkTo={extensionURL}
          size={ButtonSize.Small}
          targetBlank
          data-test-selector={TestSelectors.ExtensionPageButton}
        >
          Extension Page
        </Button>
      </StyledLayout>
      <StyledLayout fullWidth textAlign={TextAlign.Center} flexOrder={1}>
        <Button
          data-track-click="report-extension-embed-copy-email-template"
          type={ButtonType.Text}
          fullWidth
          size={ButtonSize.Small}
          targetBlank
          onClick={copyEmailTemplateToClipboard}
          data-test-selector={TestSelectors.CopyEmailTemplateButton}
        >
          Copy email template
        </Button>
      </StyledLayout>
    </StyledLayout>
  );
};
