import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import * as ReportModels from "aegis/features/reports/models";
import { DataSelector, LegacyEmbed } from "./legacy-embed";
import { NewReport } from "./testutil";

Enzyme.configure({ adapter: new Adapter() });

it("renders with all optional fields", () => {
  const report = NewReport() as ReportModels.LegacyReport;

  report.extra = "extra";
  report.details = "details";
  report.contentID = "contentID";

  const wrapper = Enzyme.shallow(<LegacyEmbed report={report} />);
  expect(wrapper.find({ "data-test-selector": DataSelector.ContentID }).exists()).toBeTruthy();
  expect(wrapper.find({ "data-test-selector": DataSelector.Extra }).exists()).toBeTruthy();
  expect(wrapper.find({ "data-test-selector": DataSelector.Details }).exists()).toBeTruthy();
});

it("renders without optional fields", () => {
  const report = NewReport() as ReportModels.LegacyReport;

  const wrapper = Enzyme.shallow(<LegacyEmbed report={report} />);
  expect(wrapper.find({ "data-test-selector": DataSelector.ContentID }).exists()).toBeFalsy();
  expect(wrapper.find({ "data-test-selector": DataSelector.Extra }).exists()).toBeFalsy();
  expect(wrapper.find({ "data-test-selector": DataSelector.Details }).exists()).toBeFalsy();
});
