import * as React from "react";

import { LegacyReport } from "aegis/features/reports";
import { CoreText, FormGroup, Layout } from "twitch-core-ui";

import "./styles.scss";

export const DataSelector = {
  ContentID: "legacyEmbed.contentID",
  Extra: "legacyEmbed.extra",
  Details: "legacyEmbed.details"
};

interface Props {
  report: LegacyReport;
}

export const LegacyEmbed: React.SFC<Props> = props => {
  const { report } = props;

  return (
    <Layout>
      {!!report.contentID && (
        <FormGroup id={`content-embed-${report.id}`} label="Content ID" data-test-selector={DataSelector.ContentID}>
          <CoreText> {report.contentID}</CoreText>
        </FormGroup>
      )}

      {!!report.extra && (
        <FormGroup id={`extra-embed-${report.id}`} label="Extra" data-test-selector={DataSelector.Extra}>
          <pre className="legacy-content">{report.extra}</pre>
        </FormGroup>
      )}

      {!!report.details && (
        <FormGroup id={`details-embed-${report.id}`} label="Details" data-test-selector={DataSelector.Details}>
          <pre className="legacy-content">{report.details}</pre>
        </FormGroup>
      )}
    </Layout>
  );
};
