import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { MockedProvider } from "react-apollo/test-utils";
import { Router } from "react-router-dom";

import * as ReportModels from "aegis/features/reports/models";
import { createHistory } from "aegis/functionality/utils/contrib/twilight/history";
import { LiveUpNotificationEmbed } from "./live-up-notification-embed";
import { NewLiveUpNotificationReport } from "./testutil";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

function setupMount(overrides?: Partial<ReportModels.LiveUpNotificationReport>) {
  const report = NewLiveUpNotificationReport(overrides ? overrides : {});
  return Enzyme.mount(
    <Router history={createHistory()}>
      <MockedProvider>
        <LiveUpNotificationEmbed report={report} />
      </MockedProvider>
    </Router>
  );
}

describe("LiveUpNotificationEmbed", () => {
  it("renders placeholder when no message is provided", () => {
    const wrapper = setupMount({ message: undefined });

    expect(wrapper.text()).toBe("Couldn't fetch the exact message for this live up notification");
  });

  it("renders ui correctly", () => {
    const wrapper = setupMount();

    expect(wrapper.text()).toBe("display is live: some reportable message!");
  });
});
