import * as React from "react";

import { LiveUpNotificationReport } from "aegis/features/reports";
import { Color, CoreText } from "twitch-core-ui";

interface Props {
  report: LiveUpNotificationReport;
}

export const LiveUpNotificationEmbed: React.SFC<Props> = ({ report }) => {
  if (!report.message) {
    return <CoreText color={Color.Error}>Couldn't fetch the exact message for this live up notification</CoreText>;
  }

  const targetUserNamePrefix = report.targetUser && `${report.targetUser.displayName} is live: `;

  return (
    <CoreText>
      {targetUserNamePrefix}
      {report.message}
    </CoreText>
  );
};
