import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { RoomEmbed, TestSelectors } from "./room-embed";
import { NewRoomReport } from "./testutil";

Enzyme.configure({ adapter: new Adapter() });

describe("RoomReportEmbed", () => {
  it("renders ", () => {
    const report = NewRoomReport();

    const wrapper = Enzyme.shallow(<RoomEmbed report={report} />);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Chatroom }).exists()).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.Messages }).exists()).toBeTruthy();
  });
});
