import * as React from "react";

import { Chatroom } from "aegis/features/chatrooms";
import { DeleteChatroomMessageButton } from "aegis/features/chatrooms/delete-chatroom-message-button";
import { Message, MessageColumn, MessageLog } from "aegis/features/messages";
import { RoomReport } from "aegis/features/reports";
import { Color, CoreText, Display, FlexDirection, JustifyContent, Layout, StyledLayout } from "twitch-core-ui";

export enum TestSelectors {
  Chatroom = "chatroom",
  Messages = "messages"
}
export interface PublicProps {
  report: RoomReport;
}

type Props = PublicProps;

export class RoomEmbed extends React.Component<Props> {
  public render() {
    const { room, messages } = this.props.report;

    if (!room) {
      return <CoreText color={Color.Error}>Malformed report data: room missing</CoreText>;
    }

    if (!messages) {
      return <CoreText color={Color.Error}>Malformed report data: comment missing</CoreText>;
    }

    return (
      <Layout display={Display.Flex} flexDirection={FlexDirection.Column} justifyContent={JustifyContent.Between}>
        <StyledLayout margin={{ top: 0.5, bottom: 0.5 }} fullWidth>
          <Chatroom room={room} data-test-selector={TestSelectors.Chatroom} />
        </StyledLayout>
        <Layout fullWidth>
          <MessageLog
            data-test-selector={TestSelectors.Messages}
            entries={messages}
            chatColumns={[MessageColumn.Time, MessageColumn.From, MessageColumn.Message, MessageColumn.Actions]}
            additionalActionFactory={this.additionalActionsFactory}
          />
        </Layout>
      </Layout>
    );
  }

  private additionalActionsFactory = (message: Message) => {
    return [
      <DeleteChatroomMessageButton
        key="delete-chatroom-message-button"
        roomID={this.props.report.room!.id}
        message={message}
      />
    ];
  };
}
