import { fakeMessage } from "aegis/features/messages/mocks";
import * as ReportModels from "aegis/features/reports/models";
import { ReportContentCode } from "aegis/models";
import { MockAdmin, MockChatroom, MockUser, MockVod } from "aegis/models/mocks";
import { MockReportContent, MockReportReason } from "aegis/models/mocks/report";

export function NewReport(): ReportModels.Report {
  return {
    id: "id",
    audits: [],
    assignedto: MockAdmin(),
    assignedToQueue: ReportModels.ReportQueue.Main,
    status: "status",
    content: MockReportContent(),
    reason: MockReportReason(),
    language: "language",
    createdAt: "createdAt",
    updatedAt: "updatedAt",
    fromUser: MockUser(),
    targetUser: MockUser(),
    description: "description",
    origin: "origin"
  };
}

export function NewClipReport(
  overrides: Partial<ReportModels.ClipReport | ReportModels.Report>
): ReportModels.ClipReport {
  const report = NewReport();
  return {
    ...report,
    clipOverviewURL: "clipOverviewURL",
    clipURL: "clipURL",
    vodURL: "vodURL",
    slug: "slug",
    ...overrides
  } as ReportModels.ClipReport;
}

export function NewVodCommentReport(
  overrides: Partial<ReportModels.VodCommentReport | ReportModels.Report>
): ReportModels.VodCommentReport {
  const report = NewReport();
  return {
    ...report,
    vodURL: "vodURL",
    vodComment: fakeMessage,
    ...overrides
  } as ReportModels.VodCommentReport;
}

export function NewChatReport(
  overrides: Partial<ReportModels.ChatReport | ReportModels.Report>
): ReportModels.ChatReport {
  const report = NewReport();
  return {
    ...report,
    content: MockReportContent({ code: ReportContentCode.Chat }),
    ...overrides
  } as ReportModels.ChatReport;
}

export function NewEmoteReport(overrides?: Partial<ReportModels.EmoteReport>): ReportModels.EmoteReport {
  const report = NewReport();
  return {
    ...report,
    emote: {
      id: "id",
      code: "code"
    },
    ...overrides
  } as ReportModels.EmoteReport;
}

export function NewExtensionReport(
  overrides: Partial<ReportModels.ExtensionReport | ReportModels.Report>
): ReportModels.ExtensionReport {
  const report = NewReport();
  return {
    ...report,
    content: MockReportContent({ code: ReportContentCode.Extension }),
    extensionID: "someextensionid",
    extensionURL: "https://www.twitch.tv/ext/someextensionid",
    targetUser: {
      id: "someuserid",
      login: "someuserlogin"
    },
    ...overrides
  } as ReportModels.ExtensionReport;
}

export function NewLiveUpNotificationReport(
  overrides: Partial<ReportModels.LiveUpNotificationReport | ReportModels.Report>
): ReportModels.LiveUpNotificationReport {
  const report = NewReport();
  return {
    ...report,
    content: MockReportContent({ code: ReportContentCode.LiveUp }),
    message: "some reportable message!",
    ...overrides
  } as ReportModels.LiveUpNotificationReport;
}

export function NewRoomReport(overrides?: Partial<ReportModels.RoomReport>): ReportModels.RoomReport {
  const report = NewReport();
  return {
    ...report,
    room: MockChatroom(),
    messages: [fakeMessage],
    ...overrides
  };
}

export function NewWhisperReport(
  overrides: Partial<ReportModels.WhisperReport | ReportModels.Report>
): ReportModels.WhisperReport {
  const report = NewReport();
  return {
    ...report,
    content: MockReportContent({ code: ReportContentCode.Whisper }),
    messages: [],
    ...overrides
  } as ReportModels.WhisperReport;
}

export function NewVodReport(
  overrides?: Partial<ReportModels.VodReport | ReportModels.Report>
): ReportModels.VodReport {
  const report = NewReport();
  return {
    ...report,
    content: MockReportContent({ code: ReportContentCode.Vod }),
    vod: MockVod(),
    ...overrides
  } as ReportModels.VodReport;
}

export function NewUserReport(overrides?: Partial<ReportModels.UserReport>): ReportModels.UserReport {
  const report = NewReport();
  return {
    ...report,
    content: MockReportContent({ code: ReportContentCode.User }),
    similarClipsURL: "similarClipsURL",
    chatPopupURL: "chatPopupURL",
    vod: MockVod(),
    ...overrides
  } as ReportModels.UserReport;
}
