import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { VodReport } from "aegis/features/reports";
import { MockVod } from "aegis/models/mocks";
import { NewUserReport } from "./testutil";
import { TestSelectors, UserEmbed } from "./user-embed";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

function setupShallow(overrides?: Partial<VodReport>) {
  const report = NewUserReport(overrides);
  return Enzyme.shallow(<UserEmbed report={report} />);
}

describe("UserReportEmbed", () => {
  it("renders with no vod", () => {
    const wrapper = setupShallow({ vod: undefined });

    expect(wrapper.find(UserEmbed)).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.VOD_EMBED })).toHaveLength(0);
    expect(wrapper.find({ "data-test-selector": TestSelectors.VOD_EMBED_TOGGLE_BUTTON }).prop("disabled")).toBe(true);
  });

  it("renders with vod", () => {
    const wrapper = setupShallow({ vod: MockVod() });

    expect(wrapper.find(UserEmbed)).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.VOD_EMBED })).toHaveLength(0);

    const toggleButton = wrapper.find({ "data-test-selector": TestSelectors.VOD_EMBED_TOGGLE_BUTTON });
    expect(toggleButton).toHaveLength(1);
    expect(toggleButton.prop("disabled")).toBe(false);
    toggleButton.simulate("click");
    expect(wrapper.find({ "data-test-selector": TestSelectors.VOD_EMBED })).toHaveLength(1);
  });
});
