import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { VodReport } from "aegis/features/reports";
import { MockVod } from "aegis/models/mocks";
import { NewVodReport } from "./testutil";
import { TestSelectors, VodEmbed } from "./vod-embed";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

function setupShallow(overrides?: Partial<VodReport>) {
  const report = NewVodReport(overrides);
  return Enzyme.shallow(<VodEmbed report={report} />);
}

describe("VodReportEmbed", () => {
  it("renders with no vod", () => {
    const wrapper = setupShallow({ vod: undefined });

    expect(wrapper.find(VodEmbed)).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.ErrorText })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.VideoEmbed })).toHaveLength(0);
  });

  it("renders with vod", () => {
    const wrapper = setupShallow({ vod: MockVod() });

    expect(wrapper.find(VodEmbed)).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.ErrorText })).toHaveLength(0);
    expect(wrapper.find({ "data-test-selector": TestSelectors.VideoEmbed })).toHaveLength(1);
  });
});
