import * as React from "react";

import { VodReport } from "aegis/features/reports";
import { VodVideoEmbed } from "aegis/features/vod";

import { Color, CoreText, Layout } from "twitch-core-ui";

import "./styles.scss";

interface Props {
  report: VodReport;
}

export enum TestSelectors {
  ErrorText = "vod-embed--error-text",
  VideoEmbed = "vod-embed--video-embed"
}
export const VodEmbed: React.SFC<Props> = ({ report }) => {
  const { vod } = report;

  if (!vod) {
    return (
      <Layout data-test-selector={TestSelectors.ErrorText}>
        <CoreText color={Color.Error}>There is no vod associated with this report</CoreText>
      </Layout>
    );
  }

  return <VodVideoEmbed vod={vod} data-test-selector={TestSelectors.VideoEmbed} />;
};
