import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { MockedProvider } from "react-apollo/test-utils";
import { Router } from "react-router-dom";

import { MessageColumn } from "aegis/features/messages";
import { ResponseWithNTwitchWhisperMessages } from "aegis/features/messages/mocks";
import * as ReportModels from "aegis/features/reports/models";
import "aegis/functionality/date-extensions";
import { createHistory } from "aegis/functionality/utils/contrib/twilight/history";
import { NewWhisperReport } from "./testutil";
import { DataSelectors, WhisperReportEmbed } from "./whisper-report-embed";

Enzyme.configure({ adapter: new Adapter() });

function setupMount(overrides?: Partial<ReportModels.WhisperReport>) {
  const report = NewWhisperReport(overrides ? overrides : {});
  return Enzyme.mount(
    <Router history={createHistory()}>
      <MockedProvider>
        <WhisperReportEmbed report={report} />
      </MockedProvider>
    </Router>
  );
}

describe("WhisperReportEmbed", () => {
  it("renders ui correctly", () => {
    const wrapper = setupMount({ messages: ResponseWithNTwitchWhisperMessages(10) });

    expect(wrapper.find({ "data-test-selector": DataSelectors.Messages }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": DataSelectors.Messages }).props()).toMatchObject({
      chatColumns: [MessageColumn.Time, MessageColumn.From, MessageColumn.Message]
    });
    expect(wrapper.find({ "data-test-selector": DataSelectors.Messages }).prop("entries").length).toBe(10);
    expect(wrapper.find({ "data-test-selector": DataSelectors.ShowAllReports })).toBeDefined();
  });
});
