import * as React from "react";

import { CollapsibleMessageLog, MessageColumn } from "aegis/features/messages";
import { WhisperReport } from "aegis/features/reports";
import { Button, ButtonType, Display, FlexDirection, JustifyContent, Layout, TextAlign } from "twitch-core-ui";

export const DataSelectors = {
  Messages: "whisperReportEmbed.messages",
  ShowAllReports: "whisperReportEmbed.showAllReports"
};

interface Props {
  report: WhisperReport;
}

export class WhisperReportEmbed extends React.Component<Props> {
  public render() {
    return (
      <>
        <CollapsibleMessageLog
          data-test-selector={DataSelectors.Messages}
          entries={this.props.report.messages ? this.props.report.messages : []}
          chatColumns={[MessageColumn.Time, MessageColumn.From, MessageColumn.Message]}
        />
        <Layout
          display={Display.Flex}
          flexDirection={FlexDirection.Row}
          justifyContent={JustifyContent.Between}
          margin={{ top: 0.5 }}
        >
          <Layout />
          {this.props.report.targetUser && (
            <Layout margin={{ x: 0.5 }} textAlign={TextAlign.Right}>
              <Layout>
                <Button
                  data-track-click="whisper-embed-search-related"
                  data-test-selector={DataSelectors.ShowAllReports}
                  linkTo={`/reportsearch?content=whisper_report&targetUserID=${this.props.report.targetUser.id}`}
                  targetBlank
                  type={ButtonType.Hollow}
                >
                  {"View all whisper reports for this user"}
                </Button>
              </Layout>
            </Layout>
          )}
        </Layout>
      </>
    );
  }
}
