import * as React from "react";

import { shallow } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockUser } from "aegis/models/mocks";
import { mockReport } from "../../reportMocks";
import { Props, ReportHeader, TestSelectors } from "./component";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

const setup = (overrides?: Partial<Props>) => {
  const combinedProps = {
    report: mockReport({ fromUser: MockUser(), targetUser: MockUser() }),
    ...overrides
  };
  const wrapper = shallow(<ReportHeader {...combinedProps} />);
  return {
    props: combinedProps,
    wrapper
  };
};

describe("Report User", () => {
  it("renders with a valid User", () => {
    const { wrapper } = setup();
    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.ReportTargetUser })
        .children()
        .text()
    ).toBe("display");
  });

  it("renders with report language", () => {
    const { wrapper } = setup({ report: mockReport({ language: "en" }) });

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.ReportLanguage })
        .children()
        .first()
        .text()
    ).toBe("EN");
  });

  it("renders without report language", () => {
    const { wrapper } = setup();

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.ReportLanguage })
        .children()
        .first()
        .text()
    ).toBe("??");
  });
});
