import { Report } from "aegis/features/reports";
import * as classnames from "classnames";
import * as React from "react";
import {
  AlignItems,
  Background,
  BorderRadius,
  ButtonType,
  CoreText,
  Display,
  FontSize,
  JustifyContent,
  Layout,
  Position,
  StyledLayout
} from "twitch-core-ui";

import { TranslateButton } from "aegis/features/translate";
import "./styles.scss";

interface Props {
  report: Report;
  expanded?: boolean;
}

export class ReportDescription extends React.Component<Props> {
  public render() {
    const { expanded } = this.props;
    const { description } = this.props.report;
    const translateButton = (
      <Layout>
        <TranslateButton for={description} label="Translate" type={ButtonType.Text} />
      </Layout>
    );
    const wrapperClasses = classnames(
      "report-description",
      { "report-description": expanded },
      { "tw-full-width": expanded },
      { "tw-ellipsis": !expanded }
    );
    const descriptionHeader = (
      <Layout margin={{ right: 0.5 }}>
        <CoreText>Report Description</CoreText>
      </Layout>
    );

    return (
      <div className={wrapperClasses}>
        <StyledLayout
          background={Background.Base}
          padding={{ x: 1, y: expanded ? 1 : 0.5 }}
          borderRadius={BorderRadius.Large}
          margin={{ top: 0.5 }}
          className={!expanded ? "tw-ellipsis" : ""}
          fullWidth={expanded}
          border
        >
          <Layout padding={{ x: 0.5 }} position={Position.Relative}>
            <Layout display={Display.Flex} justifyContent={JustifyContent.Start} alignItems={AlignItems.Center}>
              {expanded && descriptionHeader}
              {expanded && translateButton}
            </Layout>
            <Layout>
              <CoreText fontSize={FontSize.Size4} ellipsis={!expanded}>
                {description}
              </CoreText>
            </Layout>
          </Layout>
        </StyledLayout>
      </div>
    );
  }
}
