import * as React from "react";

import { createContext } from "aegis/functionality/utils/contrib/twilight/context";
import { User } from "aegis/models";

export interface ReportActionContext {
  openStrikeForm: (user: User) => void;
  closeStrikeForm: () => void;
  hideReport?: () => void;
  onCancelHold?: () => void;
  onAutoResolve?: () => void;
}

const actionsInitValues: ReportActionContext = {
  openStrikeForm: () => undefined,
  closeStrikeForm: () => undefined
};

export const { InnerProvider: ReportActionsInnerProvider, withContext: withReportActionContext } = createContext<
  ReportActionContext
>("ReportActionContext", actionsInitValues);

export class ReportActionContextProvider extends React.Component<ReportActionContext> {
  public render() {
    return <ReportActionsInnerProvider value={this.props}>{this.props.children}</ReportActionsInnerProvider>;
  }
}

export function reportActionContextMapper(context: ReportActionContext): ReportActionContext {
  return context;
}
