import * as React from "react";

import { ReportViewType } from "aegis/features/report-view";
import { ReportsComponent } from "../component";
import { Report } from "../models";

import { CoreText, TextType } from "twitch-core-ui";
import { QueueHeader } from "../header";

export interface Props {
  reportEntries: Report[];
  hideReport: (report: Report) => void;
}

export class AllHeldReportsComponent extends React.Component<Props> {
  public render() {
    const { reportEntries, hideReport } = this.props;
    return (
      <>
        <QueueHeader>
          <CoreText type={TextType.H3}>Showing {reportEntries.length} Held Report(s)</CoreText>
        </QueueHeader>
        <ReportsComponent viewType={ReportViewType.Main} reportEntries={reportEntries} onRemove={hideReport} />
      </>
    );
  }
}
