import * as React from "react";
import { Route, Switch } from "react-router";

import { Layout } from "twitch-core-ui";
import { AllHeldReports } from "./all-held-reports";
import { AllReports } from "./all-reports";
import { InvestigativeReports } from "./investigative-reports";
import { MyAssignedReports } from "./my-assigned-reports";
import { MyHeldReports } from "./my-held-reports";
import { MyReports } from "./my-reports";
import { WorkspaceTabs } from "./workspace-tabs";

export class Reports extends React.Component {
  public render() {
    return (
      <Layout className="reports" padding={{ y: 1 }}>
        <WorkspaceTabs />
        <Switch>
          <Route path="/workspaces/all/:query?" component={AllReports} />
          <Route path="/workspaces/all-hold/:query?" component={AllHeldReports} />
          <Route path="/workspaces/investigative/:query?" component={InvestigativeReports} />
          <Route path="/workspaces/my-assigned/:query?" component={MyAssignedReports} />
          <Route path="/workspaces/my-hold/:query?" component={MyHeldReports} />
          <Route path="/workspaces/:query?" component={MyReports} />
        </Switch>
      </Layout>
    );
  }
}
