import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { QueueHeader } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Report queue header", () => {
  it("renders ", () => {
    const testSelector = "report-queue-header--test-div";
    const wrapper = Enzyme.shallow(
      <QueueHeader>
        <div data-test-selector={testSelector}>hello world</div>
      </QueueHeader>
    );

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": testSelector }).length).toBe(1);
  });
});
