import * as React from "react";

import { Background, BorderRadius, Card, CardBody, Layout } from "twitch-core-ui";

import "./styles.scss";

export const QueueHeader: React.SFC = ({ children }) => {
  return (
    <Layout padding={{ top: 2 }} className="queue-header">
      <Card background={Background.Base} elevation={2} borderRadius={BorderRadius.Large}>
        <CardBody>
          <Layout fullWidth padding={{ y: 2, x: 2 }}>
            {children}
          </Layout>
        </CardBody>
      </Card>
    </Layout>
  );
};
