import * as React from "react";

import { PagedReportsComponent, Props as PagedReportProps } from "../paged-reports";

import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  LoadingSpinner,
  SpinnerSize,
  TextType
} from "twitch-core-ui";

export type Props = PagedReportProps;

export enum TestSelectors {
  Reports = "investigative-queue--reports"
}

export class InvestigativeQueueComponent extends React.Component<Props> {
  public render() {
    const { reportEntries } = this.props;

    if (reportEntries.length === 0) {
      return (
        <Layout
          fullWidth
          padding={{ y: 1 }}
          display={Display.Flex}
          alignItems={AlignItems.Center}
          justifyContent={JustifyContent.Center}
          flexDirection={FlexDirection.Column}
        >
          <Layout display={Display.Inline} padding={1}>
            <CoreText type={TextType.H4} color={Color.Alt2}>
              No reports in investigative queue... Waiting for more...
            </CoreText>
          </Layout>
          <Layout padding={{ top: 1, bottom: 2 }}>
            <LoadingSpinner size={SpinnerSize.Large} />
          </Layout>
        </Layout>
      );
    }

    return <PagedReportsComponent {...this.props} />;
  }
}
